function Figure1S3C()
% This script plots data from Figure 1 - figure supplement 3C for both
% replicates.

w = 0;
load("640Fab_rep1.mat"); Y0 = median(Y);
[p,q] = hist(log10(Y),20); p = p/(sum(p)); %i = find(p<.001); q(i) = []; p(i) = [];
plot([p fliplr(-p)]+w*0.4,[q fliplr(q)]); drawnow; hold on;
plot([-.1 .1]+w*0.4,median(log10(Y))*[1 1],'k');
w = w + 1;

load("488Fab_640SrtA_rep1.mat"); Y1 = median(Y);
[p,q] = hist(log10(Y),20); p = p/(sum(p)); %i = find(p<.001); q(i) = []; p(i) = [];
plot([p fliplr(-p)]+w*0.4,[q fliplr(q)]); drawnow; hold on;
plot([-.1 .1]+w*0.4,median(log10(Y))*[1 1],'k');
ylim([0 7]); xlim([-.4 .8]);
axis square;
xticks([0 0.4]);
xticklabels({'D25','SrtA-F'});
ylabel('log10 Cy5 intensity per particle')
disp(['Relative median intensities Srt-A:Fab (rep.1): ',num2str(Y1/Y0)])

figure;
w = 0;
load("640Fab_rep2.mat"); Y0 = median(Y);
[p,q] = hist(log10(Y),20); p = p/(sum(p)); %i = find(p<.001); q(i) = []; p(i) = [];
plot([p fliplr(-p)]+w*0.4,[q fliplr(q)]); drawnow; hold on;
plot([-.1 .1]+w*0.4,median(log10(Y))*[1 1],'k');
w = w + 1;

load("488Fab_640SrtA_rep2.mat"); Y1 = median(Y);
[p,q] = hist(log10(Y),20); p = p/(sum(p)); %i = find(p<.001); q(i) = []; p(i) = [];
plot([p fliplr(-p)]+w*0.4,[q fliplr(q)]); drawnow; hold on;
plot([-.1 .1]+w*0.4,median(log10(Y))*[1 1],'k');
ylim([0 7]); xlim([-.4 .8]);
axis square;
xticks([0 0.4]);
xticklabels({'D25','SrtA-F'});
ylabel('log10 Cy5 intensity per particle')
disp(['Relative median intensities Srt-A:Fab (rep.1): ',num2str(Y1/Y0)])